////////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) since 1999. VASCO DATA SECURITY
// All rights reserved. http://www.vasco.com
//
////////////////////////////////////////////////////////////////////////////////

#import <Foundation/Foundation.h>
NS_ASSUME_NONNULL_BEGIN

@class OnlineActivationInputError;

/**
 * The {@link ActivationDelegate} protocol defines the minimal methods that must be implemented
 * in order to receive delegates during the activation process.
 */
NS_REFINED_FOR_SWIFT
@protocol ActivationDelegate <NSObject>

/**
 * Called upon activation process success.
 */
- (void)onActivationSuccess;

/**
 * Called upon activation process aborted.
 */
- (void)onActivationAborted;

/**
 * Called upon activation process error due to bad user input.
 * @param error returned error
 */
- (void)onActivationInputError:(OnlineActivationInputError *)error;

@end

NS_ASSUME_NONNULL_END
